/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.RelativeLocator;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ResizeHandles {
    protected int minWidth = 1;
    protected int minHeight = 1;

    public void addHandles(Figure f, Vector handles) {
        this.addHandles(f, handles, 1, 1);
    }

    public void addHandles(Figure f, Vector handles, int minWidth, int minHeight) {
        this.minHeight = minHeight;
        this.minWidth = minWidth;
        handles.addElement(new SouthEastHandle(f));
        handles.addElement(new SouthWestHandle(f));
        handles.addElement(new NorthEastHandle(f));
        handles.addElement(new NorthWestHandle(f));
    }

    public void setMinSize(int width, int height) {
        this.minWidth = width;
        this.minHeight = height;
    }

    protected class NorthWestHandle
    extends LocatorHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest());
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle r = this.owner().displayBox();
            this.owner().displayBox(new Point(Math.min(r.x + r.width - ResizeHandles.this.minWidth, x), Math.min(r.y + r.height - ResizeHandles.this.minHeight, y)), new Point(r.x + r.width, r.y + r.height));
        }
    }

    protected class NorthEastHandle
    extends LocatorHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast());
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle r = this.owner().displayBox();
            this.owner().displayBox(new Point(r.x, Math.min(r.y + r.height - ResizeHandles.this.minHeight, y)), new Point(Math.max(r.x + ResizeHandles.this.minWidth, x), r.y + r.height));
        }
    }

    protected class SouthEastHandle
    extends LocatorHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast());
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle r = this.owner().displayBox();
            this.owner().displayBox(new Point(r.x, r.y), new Point(Math.max(r.x + ResizeHandles.this.minWidth, x), Math.max(r.y + ResizeHandles.this.minHeight, y)));
        }
    }

    protected class SouthWestHandle
    extends LocatorHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest());
        }

        public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
            Rectangle r = this.owner().displayBox();
            this.owner().displayBox(new Point(Math.min(r.x + r.width - ResizeHandles.this.minWidth, x), r.y), new Point(r.x + r.width, Math.max(r.y + ResizeHandles.this.minHeight, y)));
        }
    }
}

